import viz

class BumpMapping(object):
	
	def __init__(self):
		self.__vert = """		
		uniform vec3 fvLightPosition;
		uniform vec3 fvEyePosition;

		varying vec2 Texcoord;
		varying vec3 ViewDirection;
		varying vec3 LightDirection;

		attribute vec3 rm_Binormal;
		attribute vec3 rm_Tangent;

		void main( void )
		{
			gl_Position = ftransform();
			Texcoord    = gl_MultiTexCoord0.xy;

			vec4 fvObjectPosition = gl_ModelViewMatrix * gl_Vertex;

			vec3 fvViewDirection  = fvEyePosition - fvObjectPosition.xyz;
			vec3 fvLightDirection = fvLightPosition - fvObjectPosition.xyz;
	
			vec3 fvNormal         = gl_NormalMatrix * gl_Normal;
			vec3 fvBinormal       = gl_NormalMatrix * rm_Binormal;
			vec3 fvTangent        = gl_NormalMatrix * rm_Tangent;

			ViewDirection.x  = dot( fvTangent, fvViewDirection );
			ViewDirection.y  = dot( fvBinormal, fvViewDirection );
			ViewDirection.z  = dot( fvNormal, fvViewDirection );

			LightDirection.x  = dot( fvTangent, fvLightDirection.xyz );
			LightDirection.y  = dot( fvBinormal, fvLightDirection.xyz );
			LightDirection.z  = dot( fvNormal, fvLightDirection.xyz );
		} """
		
		self.__frag = """
		uniform vec4 fvAmbient;
		uniform vec4 fvSpecular;
		uniform vec4 fvDiffuse;
		uniform float fSpecularPower;

		uniform sampler2D baseMap;
		uniform sampler2D bumpMap;

		varying vec2 Texcoord;
		varying vec3 ViewDirection;
		varying vec3 LightDirection;

		void main( void )
		{
			vec3  fvLightDirection = normalize( LightDirection );
			vec3  fvNormal         = normalize( ( texture2D( bumpMap, Texcoord ).xyz * 2.0 ) - 1.0 );
			float fNDotL           = dot( fvNormal, fvLightDirection ); 

			vec3  fvReflection     = normalize( ( ( 2.0 * fvNormal ) * fNDotL ) - fvLightDirection ); 
			vec3  fvViewDirection  = normalize( ViewDirection );
			float fRDotV           = max( 0.0, dot( fvReflection, fvViewDirection ) );

			vec4  fvBaseColor      = texture2D( baseMap, Texcoord );

			vec4  fvTotalAmbient   = fvAmbient * fvBaseColor; 
			vec4  fvTotalDiffuse   = fvDiffuse * fNDotL * fvBaseColor; 
			vec4  fvTotalSpecular  = fvSpecular * ( pow( fRDotV, fSpecularPower ) );

			gl_FragColor = ( fvTotalAmbient + fvTotalDiffuse + fvTotalSpecular );
		} """
		
		# Creating shader
		self.__shader = viz.addShader(vert=self.__vert, frag=self.__frag)
		
		# Adding vertex uniforms
		ufvLightPosition	= viz.addUniformFloat('fvLightPosition', 0, 0, 0);
		ufvEyePosition 		= viz.addUniformFloat('fvEyePosition', 0,0,0);
		#urm_Binormal 		= viz.addUniformFloat('rm_Binormal', 0,0,0);
		#urm_Tangent 		= viz.addUniformFloat('rm_Tangent', 0,0,0);
		
		# Adding fragment uniforms
		ufvAmbient		= viz.addUniformFloat('fvAmbient', .35,.35,.35,1);
		ufvSpecular 	= viz.addUniformFloat('fvSpecular',.50,.50,.50,1);
		ufvDiffuse 		= viz.addUniformFloat('fvDiffuse', .80,.80,.80,1);
		ufSpecularPower	= viz.addUniformFloat('fSpecularPower', 5);
		
		ubaseMap 		= viz.addUniformInt('baseMap', 0);
		ubumpMap		= viz.addUniformInt('bumpMap', 1);
		
		self.__shader.attach(ufvLightPosition)
		self.__shader.attach(ufvEyePosition)
		#self.__shader.attach(urm_Binormal)
		#self.__shader.attach(urm_Tangent)
		
		self.__shader.attach(ufvAmbient)
		self.__shader.attach(ufvSpecular)
		self.__shader.attach(ufvDiffuse)
		self.__shader.attach(ufSpecularPower)
		
		self.__shader.attach(ubaseMap)
		self.__shader.attach(ubumpMap)

	def applyfx(self, node):
		node.apply(self.__shader)
		

